#!/bin/sh

boxmodel=`cat /etc/boxmodel`
fakekernel=`uname -r`

prefix=/usr
exec_prefix=/usr
datarootdir=${prefix}/share

if [ -x /var/config/start.sh ]; then
	/var/config/start.sh
fi

if [ -e /lib/modules/$fakekernel/kernel/fake/fake.ko ]; then
	insmod /lib/modules/$fakekernel/kernel/fake/fake.ko
fi

#start automount
#python /etc/init.d/automount &

if [ -x /usr/bin/showiframe ]; then
	if [ -f /etc/enigma2/backdrop.mvi ]; then
		/usr/bin/showiframe /etc/enigma2/backdrop.mvi
	elif [ -f /usr/share/backdrop.mvi ]; then
		/usr/bin/showiframe /usr/share/backdrop.mvi
	fi
fi

if [$boxmodel != "solo2" ]; then
	echo "HYPERION" > /dev/vfd
else
	echo "  HYPERION  " > /dev/vfd
fi


# hook to execute scripts always before enigma2 start
if [ -x /usr/bin/enigma2_pre_start.sh ]; then
	/usr/bin/enigma2_pre_start.sh
fi

if [ -d /home/root ]; then
	cd /home/root
fi

#check for sundtek tuner helper lib
if [ -e /opt/lib/libmediaclient.so ]; then
	LIBS="/opt/lib/libmediaclient.so /usr/lib/libopen.so.0.0.0"
else
	LIBS="/usr/lib/libopen.so.0.0.0"
fi

#minidlna start
if [ -e /var/config/dlna_active ]; then
	/etc/init.d/minidlna start
else
	/etc/init.d/minidlna stop
fi

sync

(sleep 2; echo "enigma2 is the main pvr application... adjust oom score!"; PID=$(pidof enigma2); \
        [ -e /proc/$PID/oom_score_adj ] && echo "-999" > /proc/$PID/oom_score_adj || echo "-17" > /proc/$PID/oom_adj;) &

if [ "$(grep config.crash.enabledebug /etc/enigma2/settings)" == "config.crash.enabledebug=true" ]; then
	if [ "$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')" != "" -a -d "$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')" ]; then
		LD_PRELOAD=$LIBS /usr/bin/enigma2 &> $(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')Enigma2-$(date +%d-%m-%Y_%H-%M-%S).log
	else
		LD_PRELOAD=$LIBS /usr/bin/enigma2 &> /home/root/logs/Enigma2-$(date +%d-%m-%Y_%H-%M-%S).log
	fi
else
	LD_PRELOAD=$LIBS /usr/bin/enigma2
fi

# enigma2 exit codes:
#
# 1 - halt
# 2 - reboot
# 3 - restart enigma
#
# >128 signal

ret=$?
case $ret in
	1)
		/sbin/halt
		;;
	2)
		/sbin/reboot
		echo "   Reboot   " > /dev/vfd
		;;
	3)
		rm -fR /home/root/.gstreamer-0.10
		rm -f /tmp/.listen.camd.socket.ignore
		;;
	4)
		/sbin/rmmod lcd
		/usr/sbin/fpupgrade --upgrade 2>&1 | tee /home/root/fpupgrade.log
		sleep 1;
		/sbin/rmmod fp
		/sbin/modprobe fp
		/sbin/reboot
		;;
	42)
		python /usr/lib/enigma2/python/upgrade.pyo
		;;
	43)
		init 1
		;;
	*)
		rm -f /tmp/.listen.camd.socket.ignore
		;;
esac
