#!/bin/sh
################################################################################
#                                                                              #
# Polish Kathi Team 2009                                                       #
#                                                                              #
# contact: http://pkteam.pl                                                    #
#                                                                              #
################################################################################

. /var/config/emu.conf
. /var/config/newcs.conf
. /var/config/time.conf
. /var/config/swap.conf
. /var/config/highSR.conf

#-------------------------------------------------------------------------------
#language section
#-------------------------------------------------------------------------------
  info1="_(Uptime:)"
  info2="_(System partition usage:)"
  info3="_(Size:)"
  info4="_(Used:)"
  info5="_(Available:)"
  info6="_(Memory usage: )"
  info7="_(Total:)"
  info8="_(Free:)"
  info9="_(Net settings:)"
  info10="_(IP address:)"
  info11="_(Mask:)"
  info12="_(Gate:)"
  info13="_(Time:)"

#-------------------------------------------------------------------------------
#script section
#-------------------------------------------------------------------------------

upt=`uptime | awk '{print $3 " " $4}'`
echo "$info1 $upt"
echo ""
proc=`df -h / | grep rootfs | awk '{print $5}'`
echo "$info2 $proc"
size=`df -h / | grep rootfs | awk '{print $2}'`
used=`df -h / | grep rootfs | awk '{print $3}'`
available=`df -h / | grep rootfs | awk '{print $4}'`
echo "$info3 $size  $info4 $used  $info5 $available"
echo ""
echo $info6
echo ""
free1=`free | grep Mem | awk '{print $2 "  " $3 "  " $4}'`
free2=`free | grep Swap | awk '{print $2 "  " $3 "  " $4}'`
free3=`free | grep Total | awk '{print $2 "  " $3 "  " $4}'`
echo "     $info7  $info4  $info8"
echo "Mem: $free1"
echo "Swap: $free2"
echo "Total: $free3"                                      
echo ""
echo $info9
echo ""
mac=`ifconfig eth0 | grep HWaddr | awk '{print $5}'`
echo "Mac: $mac"

adres=`ifconfig eth0 | grep addr: | awk '{gsub(/:/," "); print $3}'`
echo "$info10 $adres"

maska=`ifconfig eth0 | grep addr: | awk '{gsub(/:/," "); print $7}'`
echo "$info11 $maska"

brama=`route| grep default | awk '{gsub(/:/," "); print $2}'`
echo "$info12 $brama"

dns=`cat /etc/resolv.conf | grep nameserver | awk '{gsub(/:/," "); print "DNS: "$2}'`
echo "$dns"
echo ""

echo "Emu: $emu"
echo "Newcs: $newcs"
echo "$info13 $czas"
echo "SWAP: $swap"
echo "HighSR: $highSR"
echo ""
 
exit 0
