#!/bin/sh
################################################################################
#                                                                              #
# Polish Kathi Team 2009                                                       #
#                                                                              #
# contact: http://pkteam.pl                                                    #
#                                                                              #
################################################################################

. /var/config/swap.conf
. /var/config/symlink

#-------------------------------------------------------------------------------
#language section
#-------------------------------------------------------------------------------
info1="_(Detecting SWAP partition, wait...)"
info2="_(SWAP detected on )"
info3="_(SWAP PART ON)"
info4="_(SWAP partition activated)"
info5="_(SWAP is missing or wrong partition type)"
info6="_(SWAP file emulation activated)"
info7="_(Wait...)"
info8="_(SWAP mounted)"
info9="_(SWAP is not active)"
info10="_(If you want to use SWAP partition activate it)"

#-------------------------------------------------------------------------------
#script section
#-------------------------------------------------------------------------------

if [ $swap == on ] && [ -z "`cat /proc/swaps`" ]; then

   echo $info1
   id_swap=`fdisk -l | grep 'Linux swap' | awk '{print $5}' | head -n 1`
   echo ""

   if [ $id_swap == "82" ]; then
       swap_dev=`fdisk -l | grep 'Linux swap' | awk '{print $1}' | head -n 1`
       echo $info2 $swap_dev
       echo ""
       mkswap $swap_dev
       swapon $swap_dev
       echo ""
       echo $info3 > /dev/dbox/fp0
       sleep 1
       echo $info4
       echo ""
   else
       echo $info5
       echo ""
       echo $info6
       echo ""
       echo $info7
       $SYMLINK/swap.sh >/dev/null
       echo ""
       echo $info8
       echo ""
   fi

else
    if [ -e /swap/swapfile ]; then
        rm /swap/swapfile
        rmdir /swap/
    fi
    if [ -z "`cat /proc/swaps`" ]; then
	echo $info9
	echo ""
	echo $info10
	echo ""
    else
	echo `cat /proc/swaps`
    fi
fi

exit 0
