#!/bin/sh

NAME="SCI-NG"
MOD="/var/lib/sci-ng.ko"
SCI_DEVICE="sci-ng"

# Load the modules and create device files
load_device ()
{
    rm -rf /dev/sci* > /dev/null

    # Second argument contains optional major number, else the driver gets it from the kernel
    if [ -n "$1" ] ; then
        SCI_MAJOR=$1
        /sbin/insmod $MOD sci_major=$SCI_MAJOR
    else
        /sbin/insmod $MOD
        SCI_MAJOR=`awk "\\$2==\"$SCI_DEVICE\" {print \\$1}" /proc/devices`
    fi

    # Create the sci devices
    if [ -n "$SCI_MAJOR" ]; then
        mknod /dev/sci0 c $SCI_MAJOR 0
        mknod /dev/sci1 c $SCI_MAJOR 1
    else
        echo "Error: major number is 0"
        unload_device
    fi
}

# Unload and remove files
unload_device ()
{
    /sbin/rmmod $MOD &> /dev/null
    rm -rf /dev/sci*
}


case "$1" in
  start)
     echo -n "Loading $NAME"
     load_device $2
     echo "."
     ;;
  stop)
     echo -n "Unloading $NAME"
     unload_device
     echo "."
     ;;
  force-reload|restart)
     echo -n "Reloading $NAME"
     unload_device
     load_device $2
     echo "."
     ;;
  *)
     echo "Usage: $0 {start|stop|restart|force-reload}"
     exit 1
esac

exit 0

