from Components.Converter.Converter import Converter
from Components.Element import cached
from Components.config import config

    
class EventName(Converter, object):
	NAME = 0
	SHORT_DESCRIPTION = 1
	EXTENDED_DESCRIPTION = 2
	ID = 3
	
	def __init__(self, type):
		Converter.__init__(self, type)
		if type == "Description":
			self.type = self.SHORT_DESCRIPTION
		elif type == "ExtendedDescription":
			self.type = self.EXTENDED_DESCRIPTION
		elif type == "ID":
			self.type = self.ID
		else:
			self.type = self.NAME
	
	@cached
	def getText(self):
		event = self.source.event
		if event is None:
			return ""
			
		if self.type == self.NAME:
			return event.getEventName()
		elif config.plugins.InfoBarPKT.EPGInList.value == "Off":
			return ""
		elif self.type == self.SHORT_DESCRIPTION:
			if config.plugins.InfoBarPKT.EPGInList.value == "On":
				opis = event.getExtendedDescription()  
				if opis == "":
					opis = event.getShortDescription()
			else:
				opis = event.getShortDescription()
			return opis[:-1]
		elif self.type == self.EXTENDED_DESCRIPTION:
			return event.getExtendedDescription()
		elif self.type == self.ID:
			return str(event.getEventId())
		
	text = property(getText)
