configuration_file=/var/config/backup.conf
echo "_(Configuring backup)"
backuppath=`cat $configuration_file | grep "Backuppath" | cut -d'=' -f2`
E2settings=`cat $configuration_file | grep "E2settings=yes"`
Bouquets=`cat $configuration_file | grep "Bouquets=yes"`
EMUconfig=`cat $configuration_file | grep "EMUconfig=yes"`
VARconfig=`cat $configuration_file | grep "VARconfig=yes"`
if [ ! -e $backuppath ]; then mkdir $backuppath; fi
echo "_(Removing old backup)"
rm -f $backuppath/e2settings.tar.gz
rm -f $backuppath/bukiety.tar.gz
rm -f $backuppath/var_config.tar.gz
rm -f $backuppath/emu.tar.gz
rm -f $backuppath/autorestore.sh
echo "_(Creating new backup)"
if [ $E2settings ]; then tar -cf $backuppath/e2settings.tar.gz etc/enigma2/settings; fi
if [ $Bouquets ]; then tar -cf $backuppath/bukiety.tar.gz etc/enigma2/*userbouquet*.* etc/enigma2/lamedb etc/tuxbox/**.xml*; fi
if [ $VARconfig ]; then tar -cf $backuppath/var_config.tar.gz var/config/*; fi
if [ $EMUconfig ]; then tar -cf $backuppath/emu.tar.gz var/emu/* var/keys/*; fi
echo "_(Backup created in $backuppath directory)"
echo "_(REMEMBER: This backup can be restore only from partition with RECOVERY label)"
. /var/config/symlink
. /var/config/backup.conf
cp -f $SYMLINK/backup/restore_backup.sh $Backuppath/restore_backup.sh