#!/bin/sh
################################################################################
#                                                                              #
# Polish Koders Team 2011                                                      #
#                                                                              #
# contact: http://pkteam.pl/                                                   #
#                                                                              #
################################################################################

. /var/config/swap.conf
. /var/config/symlink

#-------------------------------------------------------------------------------
#script section
#-------------------------------------------------------------------------------

if [ $swap == on ]; then

   echo "_(Detecting SWAP partition, wait...)"
   id_swap=`fdisk -l | grep 'Linux swap' | awk '{print $5}' | head -n 1`
   echo ""

   if [ $id_swap == "82" ]; then
       swap_dev=`fdisk -l | grep 'Linux swap' | awk '{print $1}' | head -n 1`
       echo "_(SWAP detected on )" $swap_dev "\n"
       mkswap $swap_dev
       swapon $swap_dev
       echo ""
       echo "SWAP PART ON" > /dev/vfd
       sleep 1
       echo "_(SWAP partition activated)" "\n"
   else
       echo "_(SWAP is missing or wrong partition type)" "\n"
       echo "_(SWAP file emulation activated)" "\n"
       echo "_(Wait...)"
       if [ ! -e /var/config/flash ]; then
            $SYMLINK/swap.sh >/dev/null
            echo ""
            echo "_(SWAP mounted)" "\n"
       else       
            test=`mount | grep hdd | awk '{print $5}'`
            if [ $test != ntfs ] && [ -n "$test" ]; then
                $SYMLINK/swap.sh >/dev/null
                echo ""
                echo "_(SWAP mounted)" "\n"
              else
                echo ""
                echo "_(error: /hdd must be mounted)" "\n"
            fi
       fi
   fi

else

  if [ ! -e /var/config/flash ]; then
    PATCH="/swap"
  else
    PATCH="/hdd/swap"
  fi

    if [ -e $PATCH/swapfile ]; then
        swapoff $PATCH/swapfile
        rm $PATCH/swapfile
        rmdir $PATCH/
    fi
  
    echo "_(SWAP is not active)" "\n"
    echo "_(If you want to use SWAP partition activate it)" "\n"
    echo "_(USB STICK or USB HARDDISK is REQUIRED)" "\n"
    echo "_(Supported Filesystem: ext2, ext3, vfat, LinuxSwap)" "\n"
fi
exit 0
