#!/bin/sh
################################################################################
#                                                                              #
# Polish Koders Team 2011                                                      #
#                                                                              #
# contact: http://pkteam.pl                                                    #
#                                                                              #
################################################################################

. /var/config/wlan.conf

#-------------------------------------------------------------------------------
#script section
#-------------------------------------------------------------------------------

if [ $wlan == off ]; then
    interface=eth0
    mac=`ifconfig $interface | grep HWaddr | awk '{print $5}'` 2>/dev/null
    echo "_(LAN MAC)" ": $mac"
else
    interface=ra0
    mac=`ifconfig $interface | grep HWaddr | awk '{print $5}'` 2>/dev/null
    echo "_(WIFI MAC)" ": $mac"
fi

adres=`ifconfig $interface | grep addr: | awk '{gsub(/:/," "); print $3}'` 2>/dev/null
echo "_(IP address:) $adres"

maska=`ifconfig $interface | grep addr: | awk '{gsub(/:/," "); print $7}'` 2>/dev/null
echo "_(Mask:) $maska"

brama=`route| grep default | awk '{gsub(/:/," "); print $2}'`
echo "_(Gate:) $brama"
status="Error _(Gate:) $brama _(doesn't reply for PING!)"
if [ `ping -c 1 $brama | grep "1 packets received" | awk '{print $1}'` ] ; then status="_(Gate:) _(replies for PING)" ; fi
echo $status

dns=`cat /etc/resolv.conf | grep nameserver | awk '{gsub(/:/," "); print "DNS: "$2}'`
dns_test=`cat /etc/resolv.conf | grep nameserver | awk '{gsub(/:/," "); print $2}' | tail -1`
echo "$dns"
status="_(Error) $dns_test _(doesn't resolve names!)"
if [ `nslookup 'www.wp.pl' "$dns_test" | grep "Address" | grep "www.wp.pl" | awk '{print $3}'` ] ; then status="_(Name server resolves names properly)" ; fi
echo $status
echo

echo "_(Server PKT connection test)"
ping -c 1 pkteam.pl
exit 0
