#!/bin/sh
################################################################################
#                                                                              #
# Polish Koders Team 2011                                                      #
#                                                                              #
# contact: http://pkteam.pl/                                                   #
#                                                                              #
################################################################################

#-------------------------------------------------------------------------------
#script section
#-------------------------------------------------------------------------------

usbserial_pl2303()
{
 echo serial=pl2303 >/var/config/usbserial.conf
 sync
 echo "_(PL2303 activated)"
 echo "\n" "_(Restart box to save changes!)"
} 

usbserial_ftdi()
{
 echo serial=ftdi >/var/config/usbserial.conf
 sync
 echo "_(FTDI activated)"
 echo "\n" "_(Restart box to save changes!)"
}

usbserial_both()
{
 echo serial=both >/var/config/usbserial.conf
 sync
 echo "_(PL2303 & FTDI activated)"
 echo "\n" "_(Restart box to save changes!)" 
}

usbserial_disable()
{
 echo serial=off >/var/config/usbserial.conf
 sync
 echo "_(PL2303 & FTDI disabled)"
 echo "\n" "_(Restart box to save changes!)"
}

status()
{
 . /var/config/usbserial.conf

    if [ $serial == off ]; then
        echo "$info5"
    elif [ $serial == pl2303 ]; then
        echo "$info1"
    elif [ $serial == ftdi ]; then
        echo "$info2"
    elif [ $serial == both ]; then
        echo "$info4"
    fi
}

#-------------------------------------------------------------------------------
#use section
#-------------------------------------------------------------------------------

case "$1" in
 'pl2303')
    usbserial_pl2303
    ;;
 'ftdi')
    usbserial_ftdi
    ;;
 'both')
    usbserial_both
    ;;
 'off')
    usbserial_disable
    ;;
 'status')
    status
    ;;
 *)
    echo -e "\nUse: usbserial.sh pl2303|ftdi|both|off|status"
    ;;
esac

echo ""
exit 0
