#!/bin/sh
################################################################################
#                                                                              #
# Polish Koders Team 2011                                                      #
#                                                                              #
# contact: http://pkteam.pl                                                    #
#                                                                              #
################################################################################

. /var/config/memory

#-------------------------------------------------------------------------------
#script section
#-------------------------------------------------------------------------------

howto()
{
 echo "_(NOTE: When wireless mode is enable LAN interface is down)"
 echo "_(If You need to re-use LAN interface You need to disable wireless support and restart tuner)" "\n"
 echo "_(If You want to use WLAN interface You need perform 3 steps:)"
 echo "_(1. Setup connection)"
 echo "_(2. Setup WLAN network)"
 echo "_(3. Re/Start Wi-Fi network)" "\n"
 echo "_(You can check if connection has been established by running the option: 'connection status')"
}

wifi_on()
{
 echo wlan=$DRIVER >/var/config/wlan.conf
 sync
 insmod /lib/modules/$DRIVER''sta.ko 2> /dev/null
 ifconfig ra0 up 2> /dev/null
 echo "_(Ralink $DRIVER driver loaded)" "\n"

    mac=`ifconfig ra0 | grep HWaddr | awk '{print $5}'`
    if [ -n "$mac" ]; then
        if [ $memory == 128MB ]; then
            echo "_(Detected Wi-Fi MAC: )" $mac "\n"
            echo "_(IMPORTANT: You have to restart GUI or reboot BOX before setup: WLAN network configuration)" "\n"
        else
            echo "_(Detected 64MB UFS910)"
            echo "_(IMPORTANT: There is a known bug on ufs910 with 64MB of memory - can not initialize wifi interface. UFS910 is required to reboot before next 3 steps configuration for proper functioning of the wireless adapter)" "\n"
        fi
        howto
    else
        echo "\nUSB WLAN Adapter is not found. \n\nProbably You don't insert adapter in USB slot or You put in device out of adapter support list"
    fi
}

wifi_off()
{
 echo wlan=off >/var/config/wlan.conf
 sync
 ifconfig ra0 down 2>/dev/null
 ifconfig wlan0 down 2>/dev/null
 rmmod rt3070sta 2>/dev/null
 rmmod rt2870sta 2>/dev/null
 rmmod rt73 2>/dev/null
 echo "_(Wi-Fi drivers deactivated)" "\n"
 echo "_(You can now use LAN interface after tuner reboot)"
}

network_restart()
{
 /etc/init.d/networking wifi-restart
}

#-------------------------------------------------------------------------------
#use section
#-------------------------------------------------------------------------------

case "$1" in
 'rt3070')
    DRIVER="rt3070"
    wifi_on
    ;;
 'rt2870')
    DRIVER="rt2870"
    wifi_on
    ;;
 'rt73')
    DRIVER="rt73"
    wifi_on
    ;;
 'off')
    wifi_off
    ;;
 'restart')
    network_restart
    ;;
 *)
    echo -e "\nUse: wlan.sh rt3070|rt2870|rt73|off|restart"
    ;;
esac

echo ""
exit 0

