#! /bin/sh

boxmodel=`cat /etc/boxmodel`
checkmod=`lsmod | grep dvb`

if [ $boxmodel == xp1000 ] && [ $checkmod => 0 ]; then
    a=1
    while test $a -le 4; do
       insmod /lib/modules/`uname -r`/extra/xp1000_$a.ko
       wait 1
       a=$(expr $a + 1)
    done
fi

rm -f /dev/vfd

if [ $boxmodel == xp1000 ]; then
  mv /dev/dbox/oled0 /dev/dbox/oled1
  ln -s /dev/dbox/oled1 /dev/vfd
else
  ln -s /dev/dbox/oled0 /dev/vfd
fi

if [ ! -e /media/RECOVERY ]; then
  mkdir /media/RECOVERY
fi 

if [ -e /media/RECOVERY/start.sh ]; then
	cd /media/RECOVERY
	chmod a+x start.sh
	./start.sh
fi

BACKUP=`findfs LABEL=RECOVERY`
if [ -n "$BACKUP" ]; then
    mount $BACKUP /media/RECOVERY
    if [ -e /media/RECOVERY/start.sh ]; then
	cd /media/RECOVERY
	chmod a+x start.sh
	./start.sh
    fi
fi 

if [ -e /etc/1stboot ]; then
        echo "detected 1stboot"
        
        if [ -n "$BACKUP" ]; then
                if [ -e /media/RECOVERY/backup/autorestore.sh ]; then
                        chmod 777 /media/RECOVERY/backup/autorestore.sh
                        echo "Autorestore RECOVERY"
                        /media/RECOVERY/backup/autorestore.sh
                fi
	elif [ -e /media/hdd/backup/autorestore.sh ]; then
                chmod 777 /media/hdd/backup/autorestore.sh
                echo "Autorestore hdd"
                /media/hdd/backup/autorestore.sh
	elif [ -e /media/usb/backup/autorestore.sh ]; then
                chmod 777 /media/usb/backup/autorestore.sh
                echo "Autorestore usb"
                /media/usb/backup/autorestore.sh
        fi


	key=`cat /var/config/keymapper`

	if [ $key == 1 ]; then
	  cp -f /usr/share/enigma2/keymap_1.xml /usr/share/enigma2/keymap.xml
	else
	  cp -f /usr/share/enigma2/keymap_2.xml /usr/share/enigma2/keymap.xml
	fi
#skin_display.xml for FPsetup 
    bm_tmp="xpeedlx mini miniplus twin 6000 6200 tt odinplus formuler1 formuler3 formuler4 formuler4turbo"
	for bm in $bm_tmp
	  do
	    if [ $boxmodel == $bm ]; then
	      cp /usr/lib/enigma2/python/Plugins/Extensions/PKT_FPsetup/screen/skin_display.xml /usr/share/enigma2/display
	    fi
	  done
  rm /etc/1stboot
fi


#SyncTime management
if grep -q "config.plugins.SyncTime.startup=true" /etc/enigma2/settings; then
    /usr/lib/enigma2/python/Plugins/Extensions/PKT/SetTime.sh
fi

if [ $boxmodel == xpeedlx ]; then
  echo "PKT" > /dev/vfd
  echo `cat /var/config/deep.corr` > /proc/stb/fp/rtc_offset
fi

#Fix network on mini
if [ $boxmodel == mini ]; then
  ifdown -a
  ifup -a
fi

#start automount
python /etc/init.d/automount &

#Startup to standby
if grep -q "config.plugins.DS.Standby=true" /etc/enigma2/settings; then
    (sleep 120 && wget http://127.0.0.1/web/powerstate?newstate=5 -O /dev/null) &
fi

exit 0 
