#!/bin/sh

boxmodel=`cat /etc/boxmodel`
fakekernel=`uname -r`

prefix=/usr
exec_prefix=/usr
datarootdir=${prefix}/share

# perform a NTP update sync, before starting Enigma2, as it is broke in OE.
if [ -x /usr/sbin/ntpdate ]; then
	/usr/sbin/ntpdate -s -u pool.ntp.org && sleep 2
fi

# hook to execute user startup script before enigma2 start
if [ -x /etc/enigma2/startup.sh ]; then
	/etc/enigma2/startup.sh
fi

if [ -e /lib/modules/$fakekernel/kernel/drivers/fake/fake.ko ]; then
	insmod /lib/modules/$fakekernel/kernel/drivers/fake/fake.ko
fi

if [ -x /usr/bin/showiframe ]; then
	if [ -f /etc/enigma2/backdrop.mvi ]; then
		/usr/bin/showiframe /etc/enigma2/backdrop.mvi
	elif [ -f /usr/share/backdrop.mvi ]; then
		/usr/bin/showiframe /usr/share/backdrop.mvi
	fi
fi

if [ -x /var/config/start.sh ]; then
	/var/config/start.sh
fi

if [ -e /var/config/smb_active ]; then
	/etc/init.d/samba restart
fi

if [ -d /home/root ]; then
	export HOME=/home/root
	cd
fi

#check for sundtek tuner helper lib
if [ -e /opt/lib/libmediaclient.so ]; then
	LIBS="/opt/lib/libmediaclient.so /usr/lib/libopen.so.0.0.0"
else
	LIBS="/usr/lib/libopen.so.0.0.0"
fi

#minidlna start
if [ -e /var/config/dlna_active ]; then
	/etc/init.d/minidlna start
else
	/etc/init.d/minidlna stop
fi

sync

(sleep 2; echo "enigma2 is the main pvr application... adjust oom score!"; PID=$(pidof enigma2); \
	[ -e /proc/$PID/oom_score_adj ] && echo "-999" > /proc/$PID/oom_score_adj || echo "-17" > /proc/$PID/oom_adj;) &

if [ "$(grep config.crash.enabledebug /etc/enigma2/settings)" == "config.crash.enabledebug=True" ]; then
	if [ "$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')" != "" -a -d "$(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')" ]; then
		LD_PRELOAD=$LIBS /usr/bin/enigma2 &> $(grep config.crash.debug_path= /etc/enigma2/settings | sed 's/config.crash.debug_path=//g')Enigma2_debug_$(date +%Y-%m-%d_%H-%M-%S).log
	else
		LD_PRELOAD=$LIBS /usr/bin/enigma2 &> /home/root/logs/Enigma2_debug_$(date +%Y-%m-%d_%H-%M-%S).log
	fi
else
	if [ ! "$(grep config.misc.firstrun=False /etc/enigma2/settings)" ]; then
		LD_PRELOAD=$LIBS /usr/bin/enigma2
	else
		LD_PRELOAD=$LIBS /usr/bin/enigma2 2> /dev/null
	fi
fi

# enigma2 exit codes:
#
# 1 - halt
# 2 - reboot
# 3 - restart enigma
#
# >128 signal

ret=$?
case $ret in
	1)
		/sbin/halt
		;;
	2)
		/sbin/reboot
		;;
	3)
		rm -f /tmp/.listen.camd.socket.ignore
		;;
	4)
		/sbin/rmmod lcd
		/usr/sbin/fpupgrade --upgrade 2>&1 | tee /home/root/fpupgrade.log
		sleep 1;
		/sbin/rmmod fp
		/sbin/modprobe fp
		/sbin/reboot
		;;
	42)
		python /usr/lib/enigma2/python/upgrade.pyo
		;;
	43)
		init 1
		;;
	44)
		# little hack but it will be fixed soon in drivers
		/usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/bin/fbclear
		/usr/bin/showiframe /usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/wait.mvi
		echo fpupload >/proc/vfd && sleep 3 && dd bs=256k if=/tmp/micom.bin of=/dev/mcu
		/usr/bin/showiframe /usr/lib/enigma2/python/Plugins/SystemPlugins/MICOMUpgrade/reboot.mvi
		# Wait forever for the user to power off
		while(true) ; do sleep 60 ; done
		;;
	*)
		rm -f /tmp/.listen.camd.socket.ignore
		;;
esac
