#!/bin/sh

usage()
{
	echo ""
	if [ "$1" != "" ]; then
		echo "[!] $1"
		echo ""
	fi
	echo "Usage : run.sh -{c|u} URL [OPTIONS] -d SEC"
	echo ""
	echo "OPTIONS:"
	echo "  -c URL             chrome mode (URL : server url)"
	echo "  -u URL             youtubetv mode (URL : server url)"
	echo "  -n URL             execute ntpd (URL : ntpd server url)"
	echo "  -r TYPE            rcu type (TYPE : de | en)"
	echo "  -x NUM             margin x"
	echo "  -y NUM             margin y"
	echo ""
	echo "example:"
	echo "  run.sh -c http://vuplus.com"
	echo "  run.sh -c http://vuplus.com -n 0.rhel.pool.ntp.org"
	echo "  run.sh -u http://youtube.com/tv"
	echo "  run.sh -u http://youtube.com/tv -n 0.rhel.pool.ntp.org"
	echo ""
	exit 0
}
remove_event_driver()
{
	EVENT_DRIVER=$(lsmod | grep chromiumos_event | cut -d' ' -f1)
	if [ "$EVENT_DRIVER" != "" ]; then
		rmmod chromiumos_event
	fi
}

if [ "$1" == "help" ]; then
	usage
fi

TOP=/usr/local/chromium
CHROME_CACHE_TOP=$TOP/config/chromium/test-user/.cache
YOUTUBETV_CACHE_TOP=$TOP/config/content_shell

export PATH=$TOP/bin:$PATH
export LD_LIBRARY_PATH=$TOP/lib:$TOP/lib/trellis:$LD_LIBRARY_PATH

export FONTCONFIG_PATH=$TOP/bin/fontConfig
export FONTCONFIG_FILE=$FONTCONFIG_PATH/fonts.conf

export SSL_CERT_FILE=$TOP/cacert.pem

export WEBKITGL_ENABLE_INPUT_EVENTS=y
export WEBKITGL_V3DDRIVER_PATH=/usr/lib/libv3ddriver.so

export XDG_CONFIG_HOME=$TOP/config
export XDG_CACHE_HOME=/tmp/config/.cache

HDD_MOUNT_POINT="$(grep '/media/hdd' /proc/mounts)"
if [ "$HDD_MOUNT_POINT" != "" ]; then
	export VDG_DOWNLOAD_DIR="/media/hdd/chromium/Downloads"
fi

export WEBKITGL_CHROME_MARGIN_X=30
export WEBKITGL_CHROME_MARGIN_Y=20

NTPD_URL=
WEBKITGL_URL=
WEBKITGL_SHELL=
DELAY_TIME=
while getopts "c:u:n:x:y:r:d:h" opt; do
	case $opt in
		c) WEBKITGL_SHELL=chrome; WEBKITGL_URL=$OPTARG ;;
		u) WEBKITGL_SHELL=browser_shell; WEBKITGL_URL=$OPTARG ;;
		n) NTPD_URL=$OPTARG ;;
		r) export WEBKITGL_RCU_TYPE=$OPTARG ;;
		x) export WEBKITGL_CHROME_MARGIN_X=$OPTARG ;;
		y) export WEBKITGL_CHROME_MARGIN_Y=$OPTARG ;;
		d) DELAY_TIME=$OPTARG ;;
		h) usage ;;
		\?) usage ;;
	esac
done

if [ "$DELAY_TIME" != "" ]; then
	sleep "$DELAY_TIME"
fi

#ntpd -nqp 0.rhel.pool.ntp.org
if [ "$NTPD_URL" != "" ]; then
	ntpd -nqp $NTPD_URL
fi

if [ "$WEBKITGL_SHELL" == "browser_shell" ]; then
	export WEBKITGL_YPUTUBE_MODE=y
	export WEBKITGL_CHROME_MARGIN_X=0
	export WEBKITGL_CHROME_MARGIN_Y=0
	export WEBKITGL_RCU_TYPE=en
	unset WEBKITGL_ENABLE_CURSOR
	unset WEBKITGL_MOUSE_POS_X
	unset WEBKITGL_MOUSE_POS_Y
else
	export WEBKITGL_MOUSE_POS_X=0
	export WEBKITGL_MOUSE_POS_Y=0
	export WEBKITGL_ENABLE_CURSOR=y
	unset WEBKITGL_YPUTUBE_MODE
fi

if [ "$WEBKITGL_RCU_TYPE" != "en" ] && [ "$WEBKITGL_RCU_TYPE" != "de" ]; then
	export WEBKITGL_RCU_TYPE=en
fi

if [ ! -e /dev/shm ]; then 
	mkdir -p /tmp/shm
	ln -s /tmp/shm /dev/shm
fi

echo "down" > /proc/stb/video/avshutdown

#remove_event_driver
#if [ -e $TOP/lib/chromiumos_event.ko ]; then
#	insmod $TOP/lib/chromiumos_event.ko
#fi
EVTDRV=$(lsmod | grep chromiumos_event)
if [ ! -n "$EVTDRV" ] ; then
	insmod $TOP/lib/chromiumos_event.ko
fi
cd $TOP/bin && $WEBKITGL_SHELL \
	--no-sandbox \
	--in-process-gpu \
	--disable-impl-side-painting \
	--test-type \
	$WEBKITGL_URL > /dev/null 2>&1

sleep 1
#remove_event_driver

echo "up" > /proc/stb/video/avshutdown
echo "0" > /proc/stb/fp/mouse

$TOP/bin/goexit

