#! /bin/sh

boxmodel=`cat /etc/boxmodel`
checkmod=`lsmod | grep dvb`
. /var/config/revision

if [ $boxmodel == xp1000 ] && [ $checkmod => 0 ]; then
    a=1
    while test $a -le 4; do
       insmod /lib/modules/`uname -r`/extra/xp1000_$a.ko
       wait 1
       a=$(expr $a + 1)
    done
fi

rm -f /dev/vfd

if [ $boxmodel == xp1000 ]; then
  mv /dev/dbox/oled0 /dev/dbox/oled1
  ln -s /dev/dbox/oled1 /dev/vfd
else
  ln -s /dev/dbox/oled0 /dev/vfd
fi

if [ ! -e /media/RECOVERY ]; then
  mkdir /media/RECOVERY
fi 

if [ -e /media/RECOVERY/start.sh ]; then
	cd /media/RECOVERY
	chmod a+x start.sh
	./start.sh
fi

BACKUP=`findfs LABEL=RECOVERY`
if [ -n "$BACKUP" ]; then
    mount $BACKUP /media/RECOVERY
    if [ -e /media/RECOVERY/start.sh ]; then
	cd /media/RECOVERY
	chmod a+x start.sh
	./start.sh
    fi
fi 

if [ -e /etc/1stboot ]; then
        echo "detected 1stboot"
        if [ -d /media/hdd/PKTFlashExtender/$VERSION ]; then
		rm -R /media/hdd/PKTFlashExtender/*
        elif [ -d /media/usb/PKTFlashExtender/$VERSION ]; then
		rm -R /media/usb/PKTFlashExtender/*
	fi
        if [ -n "$BACKUP" ]; then
                if [ -e /media/RECOVERY/backup/autorestore.sh ]; then
                        chmod 777 /media/RECOVERY/backup/autorestore.sh
                        echo "Autorestore RECOVERY"
                        /usr/bin/showiframe /usr/share/restore.mvi
                        /media/RECOVERY/backup/autorestore.sh
                fi
	elif [ -e /media/hdd/backup/autorestore.sh ]; then
                chmod 777 /media/hdd/backup/autorestore.sh
                echo "Autorestore hdd"
                /usr/bin/showiframe /usr/share/restore.mvi
                /media/hdd/backup/autorestore.sh
	elif [ -e /media/usb/backup/autorestore.sh ]; then
                chmod 777 /media/usb/backup/autorestore.sh
                echo "Autorestore usb"
                /usr/bin/showiframe /usr/share/restore.mvi
                /media/usb/backup/autorestore.sh
        fi


	key=`cat /var/config/keymapper`

	if [ $key == 1 ]; then
	  cp -f /usr/share/enigma2/keymap_1.xml /usr/share/enigma2/keymap.xml
	else
	  cp -f /usr/share/enigma2/keymap_2.xml /usr/share/enigma2/keymap.xml
	fi
	if [ -e /var/config/devices.conf ]; then
		rm /var/config/devices.conf
	fi
#skin_display.xml for FPsetup 
    bm_tmp="xpeedlx mini miniplus twin 6000 6200 opticumtt odinplus formuler1 formuler3 formuler4 formuler4turbo formuler1tc formuler3ip formuler4ip tiviarmin zgemmah7 zgemmah5 zgemmah2h sf8008 e4hdcombo ustym4kpro zgemmah9combo"
	for bm in $bm_tmp
	  do
	    if [ $boxmodel == $bm ]; then
	      cp /usr/lib/enigma2/python/Plugins/Extensions/PKT_FPsetup/screen/skin_display.xml /usr/share/enigma2/display
	    fi
	  done
  rm /etc/1stboot
fi

if [ ! -d /iptvplayer_rootfs ]; then
    mkdir /iptvplayer_rootfs
fi

if [ -d /media/hdd/PKTFlashExtender/$VERSION/usr/lib ] && [ -d /media/hdd/PKTFlashExtender/$VERSION/usr/share ] && [ -d /media/hdd/PKTFlashExtender/$VERSION/var ] && grep -q "config.plugins.PKTFlashExtender=True" /etc/enigma2/settings; then
    mount /media/hdd/PKTFlashExtender/$VERSION/usr/lib /usr/lib
    mount /media/hdd/PKTFlashExtender/$VERSION/usr/share /usr/share
    mount /media/hdd/PKTFlashExtender/$VERSION/var /var
    if [ ! -d /media/usb/PKTFlashExtender/$VERSION/iptvplayer_rootfs ]; then
	mkdir -p /media/hdd/PKTFlashExtender/$VERSION/iptvplayer_rootfs
    fi
    mount /media/hdd/PKTFlashExtender/$VERSION/iptvplayer_rootfs /iptvplayer_rootfs
elif [ -d /media/usb/PKTFlashExtender/$VERSION/usr/lib ] && [ -d /media/usb/PKTFlashExtender/$VERSION/usr/share ] && [ -d /media/usb/PKTFlashExtender/$VERSION/var ] && grep -q "config.plugins.PKTFlashExtender=True" /etc/enigma2/settings; then
    mount /media/usb/PKTFlashExtender/$VERSION/usr/lib /usr/lib
    mount /media/usb/PKTFlashExtender/$VERSION/usr/share /usr/share
    mount /media/usb/PKTFlashExtender/$VERSION/var /var
    if [ ! -d /media/usb/PKTFlashExtender/$VERSION/iptvplayer_rootfs ]; then
	mkdir -p /media/usb/PKTFlashExtender/$VERSION/iptvplayer_rootfs
    fi
    mount /media/usb/PKTFlashExtender/$VERSION/iptvplayer_rootfs /iptvplayer_rootfs
fi

#JDownlader autostart
if grep -q "config.plugins.JDownloader.autostart=True" /etc/enigma2/settings; then
    /usr/bin/jd2start.sh &
fi


#SyncTime management
if grep -q "config.plugins.SyncTime.startup=true" /etc/enigma2/settings; then
    /usr/lib/enigma2/python/Plugins/Extensions/PKT/SetTime.sh
fi

if [ $boxmodel == xpeedlx ]; then
  echo "PKT" > /dev/vfd
  echo `cat /var/config/deep.corr` > /proc/stb/fp/rtc_offset
fi

#Fix network on mini
if [ $boxmodel == mini ]; then
  ifdown -a
  ifup -a
fi

#start automount
python /etc/init.d/automount &

#Startup to standby
if grep -q "config.plugins.DS.Standby=true" /etc/enigma2/settings; then
    (sleep 120 && wget http://127.0.0.1/web/powerstate?newstate=5 -O /dev/null) &
fi

exit 0 
