#!/bin/sh
################################################################################
#                                                                              #
# Polish Koders Team 2011 - 2017                                               #
#                                                                              #
# contact: http://pkteam.pl                                                    #
#                                                                              #
################################################################################

. /var/config/box
. /var/config/link
. /var/config/symlink
. /var/config/revision
BOX=`cat /etc/boxmodel`

#-------------------------------------------------------------------------------
#script section
#-------------------------------------------------------------------------------

wget $ADRES/$VERSION/wersjas -q -O /tmp/wersjas 2>/dev/null
wget $ADRES/$VERSION/conowego -q -O /tmp/conowego 2>/dev/null
wget $ADRES_BOX/$VERSION/$BOX""_wersjas -q -O /tmp/$BOX""_wersjas 2>/dev/null
wget $ADRES_BOX/$VERSION/$BOX""_conowego -q -O /tmp/$BOX""_conowego 2>/dev/null

echo "_(Checking firmware update\n)"
if [ -e /tmp/wersjas ] && [ `stat -c%s /tmp/conowego` -gt 0 ]; then
    . /tmp/wersjas
    . /tmp/conowego
    . $SYMLINK/wersjal

    if [ $wersjal == $wersjas 2>/dev/null ]; then
        echo "_(You are using valid E2 mod PKT version -)" $wersjal
    else
        echo "_(You are using E2 mod PKT version)" $wersjal "\n"
        echo "_(Update E2 mod PKT to version)" $wersjas "\n\n"
        echo "_(What's new in)" "$wersjas :" "\n"
        echo "$co_nowego" "\n\n"
        rm -r /tmp/wersjas
        rm -r /tmp/conowego
    fi
else
    echo "\n" "_(No available updates on server or downloading error !)"
fi

echo "_(\nChecking extra $BOX update\n)"
if [ -e /tmp/$BOX""_wersjas ] && [ `stat -c%s /tmp/$BOX""_wersjas` -gt 0 ]; then

    . /tmp/$BOX""_wersjas
    . /tmp/$BOX""_conowego
    . $SYMLINK/wersjal

    if [ $wersjal == $wersjas_box 2>/dev/null ]; then
        echo "_(You are using valid E2 mod PKT version -)" $wersjal
    else
        echo "_(You are using E2 mod PKT version)" $wersjal "\n"
        echo "_(Update E2 mod PKT to version)" $wersjas_box "\n\n"
        echo "_(What's new in)" "$wersjas_box :" "\n"
        echo "$co_nowego_box" "\n\n"
        rm -r /tmp/$BOX""_wersjas
        rm -r /tmp/$BOX""_conowego
    fi
else
    echo "\n" "_(No available updates on server or downloading error !)"
fi

